#include <windows.h>
#include <stdio.h>
#include "tvichw32.h"


#include "btxxx.h"


BTxxx::BTxxx(void)
{
	detect_BT_membase();
   if (_address)
   {
		//scalerInit();
   }
}


BTxxx::~BTxxx(void)
{
	CloseTVicHW32();
}


void BTxxx::detect_BT_membase(void)
{
   if (openTvichw32() == -1)
   	FATAL("openTvichw32() failed");

   _type = 0;
   _address = 0;

   const unsigned short PCIConfigAddress = 0x0CF8;
   const unsigned short PCIConfigData    = 0x0CFC;
   unsigned long nPCIEinheit;
   unsigned long nDeviceID;

   /*
   nHardAccess = TestHardAccess();
   if(nHardAccess == TRUE)
      SetHardAccess(TRUE);
   */
   // Sucht Bt8xx von Einheit 00 bis Einheit 31
   for(int nZlr=0; nZlr<32; nZlr++)
   {
      nPCIEinheit = nZlr;
      nPCIEinheit <<= 11;
      nPCIEinheit |= 0x80000000;

      WritePortL(PCIConfigAddress, nPCIEinheit);
      nDeviceID = ReadPortL(PCIConfigData);

      // Wurde ein BT gefunden?
      switch(nDeviceID)
      {
         case BT848:
         case BT849:
         case BT878:
         case BT879:
         	_type = nDeviceID;
            // Die Adresse abfragen
            nPCIEinheit = nZlr;
            nPCIEinheit <<= 11;
            nPCIEinheit |= 0x80000010;
            WritePortL(PCIConfigAddress, nPCIEinheit);
            _nAdresse = ReadPortL(PCIConfigData);
            // Nicht bentigte Bit's ausblenden
            _nAdresse &= 0xFFFFF000;
            _address = (BTxxx_memmap*)MapPhysToLinear(_nAdresse, sizeof(BTxxx_memmap));
      }
   }
}


void BTxxx::Write(int nRegister, unsigned int nValue)
{
   unsigned int *pPhysical =
   	(unsigned int*)MapPhysToLinear(_nAdresse+nRegister, 0x04);
   *pPhysical = nValue;
}

unsigned char BTxxx::Read(int nRegister)
{
   unsigned char *pPhysical =
   	(unsigned char*)MapPhysToLinear(_nAdresse+nRegister, 0x04);
   return(*pPhysical);
}

const char* BTxxx::getTypeName(void)
{
	switch(getType())
   {
   	case BT848:
      	return("BT848");
   	case BT849:
      	return("BT849");
   	case BT878:
      	return("BT878");
   	case BT879:
      	return("BT879");
   }

  	return("Not found");
}


int BTxxx::openTvichw32(void)
{
	HINSTANCE DLLHandle = LoadLibrary("Tvichw32.dll");
	if(DLLHandle == NULL)
      return(-1);

   OpenTVicHW32 = (unsigned char (PASCAL *)(void)) GetProcAddress(DLLHandle,"OpenTVicHW32");
   MapPhysToLinear = (void* (PASCAL *)(DWORD, DWORD)) GetProcAddress(DLLHandle,"MapPhysToLinear") ;
	CloseTVicHW32 = (void (PASCAL *)(void)) GetProcAddress(DLLHandle,"CloseTVicHW32");
   ReadPortL = (DWORD (PASCAL *)(WORD)) GetProcAddress(DLLHandle,"ReadPortL");
	WritePortL = (void (PASCAL *)(WORD, DWORD)) GetProcAddress(DLLHandle,"WritePortL");
   TestHardAccess = (unsigned char (PASCAL *)(void)) GetProcAddress(DLLHandle,"TestHardAccess");
	SetHardAccess = (void (PASCAL *)(unsigned char)) GetProcAddress(DLLHandle,"SetHardAccess");
   IsDriverOpened = (unsigned char (PASCAL *) (void)) GetProcAddress(DLLHandle,"IsDriverOpened");

   if (OpenTVicHW32 == NULL)
   	FATAL("OpenTVicHW32 == NULL");

   OpenTVicHW32();

	return(0);
}


int BTxxx::getPllFrequency(void)
{
	__int64 f = _address->pll_f_lo | (_address->pll_f_hi << 8) | (_address->pll_i << 16);
	f = (f * XT0FREQ) >> 16;
	f /= ((_address->pll_c == 0) ? 6 : 4) * ((_address->pll_x == 0) ? 1 : 2);
	return((int) f );
}


void BTxxx::setPllFrequency(int data)
{
	int x,c,i,f;

	x = (data < (XT0FREQ * 2)) ? 1 : 0;
	data *= (x == 0) ? 1 : 2;
	c = (data < (XT0FREQ*8/3)) ? 0 : 1;
	data *= (c == 0) ? 6 : 4;
	i = data / XT0FREQ;
	f = (int) ((((__int64) (data % XT0FREQ) << 16) + (XT0FREQ/2)) /XT0FREQ);

	_address->pll_x = x;
	_address->pll_c = c;
	_address->pll_i = i;
	_address->pll_f_lo = (f & 0xff);
	_address->pll_f_hi = (f >> 8) & 0xff;
}

void BTxxx::setVerticalTotal(int data)
{
	data--;
	_address->vtotal_hi = (data >> 8) & 0xff;
	_address->vtotal_lo = data & 0xff;
}

int BTxxx::getBrightness(void)
{
	return(_address->bright);
}

int BTxxx::getSaturation(void)
{
	return(_address->sat_u_lo | (_address->o_sat_u_hi << 8));
}

int BTxxx::getContrast(void)
{
	return(_address->contrast_lo | (_address->o_contrast_hi << 8));
}

int BTxxx::getHue(void)
{
	return(_address->hue);
}


void BTxxx::setBrightness( int data )
{
	_address->bright = data;
}

void BTxxx::setSaturation( int data )
{
	int v = (data * 0x16a) >> 9;

	_address->sat_u_lo = data & 255;
	_address->sat_v_lo = v & 255;
	_address->e_sat_u_hi = _address->o_sat_u_hi = (data >> 8) & 1;
	_address->e_sat_v_hi = _address->o_sat_v_hi = (v >> 8) & 1;
}

void BTxxx::setContrast( int data )
{
	_address->contrast_lo = data & 255;
	_address->e_contrast_hi = _address->o_contrast_hi = (data >> 8) & 1;
}

void BTxxx::setHue( int data )
{
	_address->hue = data;
}


void BTxxx::scalerInit()
{
	int f, a;

	f = (_address->o_hscale_hi << 8) | _address->o_hscale_lo;
	_hdelay = ((f + 4096) * ((_address->o_hdelay_msb << 8) | _address->o_hdelay_lo) + 2048) >> 12;
	_hactive = ((f + 4096) * ((_address->o_hactive_msb << 8) | _address->o_hactive_lo) + 2048) >> 12;

	f = (_address->o_vscale_hi << 8) | _address->o_vscale_lo;
	a = (_address->o_vactive_msb << 8) | _address->o_vactive_lo;
	_field_height = (f == 0) ? a : (512L*a / (0x2200L - f) - 2);

	doScale();
}

void BTxxx::doScale()
{
	short s;
	int field_width = (_address->o_hactive_msb << 8) | _address->o_hactive_lo;
	int vactive = (_address->o_vactive_msb << 8) | _address->o_vactive_lo;

	if (_hactive == 0)
		s = 0;
	else
		s =  (short) ((2L*_hdelay*field_width / _hactive + 1) >> 1);

	_address->e_hdelay_msb = _address->o_hdelay_msb = (s >> 8) & 3;
	_address->e_hdelay_lo = _address->o_hdelay_lo = s & 0xff;

	if (field_width == 0)
		s = 0;
	else
		s = (short) ((8192L*_hactive / field_width - 8192L + 1) >> 1);

	_address->e_hscale_hi = _address->o_hscale_hi = (s >> 8) & 0xff;
	_address->e_hscale_lo = _address->o_hscale_lo = s & 0xff;

	if (_field_height == (vactive >> 1) || _field_height == -2)
		s = 0;
	else
		s = (short) ((0x10000L + 512L - ((512L*vactive /_field_height + 1) >> 1)) & 0x1FFFL);

	_address->e_vscale_hi = _address->o_vscale_hi = (s >> 8) & 0x1f;
	_address->e_vscale_lo = _address->o_vscale_lo = s & 0xff;
}


void BTxxx::getAnalogWindow( int *hdelay, int *hactive, int *vdelay, int *vactive )
{
	if (hdelay != 0)
		*hdelay = _hdelay;

	if (hactive != 0)
		*hactive = _hactive;

	if (vdelay != 0)
		*vdelay = (_address->o_vdelay_msb << 8) | _address->o_vdelay_lo;

	if (vactive != 0)
		*vactive = (_address->o_vactive_msb << 8) | _address->o_vactive_lo;
}

void BTxxx::getFieldSize(int *width, int *height)
{
	if (width != 0)
		*width = (_address->o_hactive_msb << 8) | _address->o_hactive_lo;

	if (height != 0)
		*height = _field_height;
}

int BTxxx::getHFilter()
{
	return(_address->o_hfilt);
}

int BTxxx::getVFilter()
{
	return(_address->o_vfilt);
}


void BTxxx::setAnalogWindow( int hdelay, int hactive, int vdelay, int vactive)
{
	_hdelay = hdelay;
	_hactive = hactive;

	_address->e_vactive_msb = _address->o_vactive_msb = (vactive >> 8) & 3;
	_address->e_vactive_lo = _address->o_vactive_lo = vactive & 0xff;
	_address->e_vdelay_msb = _address->o_vdelay_msb = (vdelay >> 8) & 3;
	_address->e_vdelay_lo = _address->o_vdelay_lo = vdelay & 0xff;

	doScale();
}


void BTxxx::setFieldSize(int width, int height)
{
	_address->e_hactive_msb = _address->o_hactive_msb = (width >> 8) & 3;
	_address->e_hactive_lo = _address->o_hactive_lo = width & 0xff;
	_field_height = height;

	doScale();
}

void BTxxx::setHFilter( int data )
{
	_address->e_hfilt = _address->o_hfilt = (int) data;
}

void BTxxx::setVFilter( int data )
{
	_address->e_vfilt = _address->o_vfilt = data;
}

void BTxxx::setAudioSource(int type)
{
	setGPOE( getGPOE() | 0x01800);
	setGPData(11, 12, type, 0x00);
}

int BTxxx::getAudioSource(void)
{
	setGPOE( getGPOE() | 0x1800);
	int ret = getGPData(11, 12, 0x00);
	return(ret);
}


int BTxxx::getGPOE(void)
{
	return(_address->gpoe & 0x00ffffffL);
}

int BTxxx::getGPData(int frombit, int tobit, int offset)
{
	int mask;

	if (frombit > 31 || tobit > 31 || frombit > tobit || offset > 0x100)
		return(0);

	mask = (1 << (1 + tobit - frombit)) - 1;
	return( (_address->GPData >> frombit) & mask );
}


void BTxxx::setGPOE(int data)
{
	_address->gpoe = data & 0x00ffffffL;
}

void BTxxx::setGPData(int frombit, int tobit, int value, int offset)
{
	long mask;

	if (frombit > 31 || tobit > 31 || frombit > tobit || offset > 0x100)
		return;

	mask = (1 << (1 + tobit)) - 1;
	long lvalue = ( (long)value << frombit ) & mask;
	_address->GPData = (_address->GPData | lvalue) & lvalue;

}


__int64 getMicroSec(void)
{
	__int64 count, freq, microsec=1000000;

	QueryPerformanceCounter( (LARGE_INTEGER*)&count );
	QueryPerformanceFrequency( (LARGE_INTEGER*)&freq );

	__asm
	{
		fild	qword ptr [count]
		fild	qword ptr [microsec]
		fmulp	st(1) , st
		fild	qword ptr [freq]
		fdivp	st(1) , st
		fistp	qword ptr [count]
	}
	return( count );
}


/*
 delays specified number of microseconds
*/
void delayMicroSec( __int64 delay )
{
	__int64 count = delay + getMicroSec();

	while (getMicroSec() < count) ;
}

void BTxxx::i2cInit()
{
	*((unsigned char *)&_address->I2C) = 0;
	i2cStart();
	i2cStop();
}


void BTxxx::i2cStart()
{
	i2cSetSDA(1);
	i2cSetSCL(1);
	i2cSetSDA(0);
	i2cSetSCL(0);
}


void BTxxx::i2cStop()
{
	i2cSetSCL(0);
	i2cSetSDA(0);
	i2cSetSCL(1);
	i2cSetSDA(1);
}


void BTxxx::i2cWrite(unsigned char value)
{
	for (int i=7; i >= 0; i--)
	{
		i2cSetSCL(0);
		i2cSetSDA((value >> i) & 1);
		i2cSetSCL(1);
	}
	i2cWaitForACK();
}


unsigned char BTxxx::i2cRead()
{
	unsigned char value=0;

	for (int i=7; i >= 0; i--)
	{
		i2cSetSCL(0);
		i2cSetSCL(1);

		value = (value << 1) | _address->I2C.sda;   // read the bit
	}

	return value;
}


void BTxxx::i2cSendNACK()
{
	i2cSetSCL(0);
	i2cSetSDA(1);
	i2cSetSCL(1);
	i2cSetSCL(0);
	i2cSetSDA(0);
}


void BTxxx::i2cSetSDA( int sda )
{
	_i2cShadow.sda = sda;
	_address->I2C = _i2cShadow;
	i2cBitDelay();
}


void BTxxx::i2cSetSCL( int scl )
{
	__int64 count;

	_i2cShadow.scl = scl;
	_address->I2C = _i2cShadow;

	count = getMicroSec() + 500000;

	while (getMicroSec() < count)
	{
		if (_address->I2C.scl == scl)
			break;
	}
	i2cBitDelay();
}


void BTxxx::i2cBitDelay()
{
	delayMicroSec(10);
}


void BTxxx::i2cWaitForACK()
{
	__int64 count;

	i2cSetSCL(0);
	i2cSetSDA(1);

	count = getMicroSec() + 500000;

	while (getMicroSec() < count)
	{
		if (_address->I2C.sda == 0)
			break;
	}

	i2cSetSCL(1);
	i2cSetSCL(0);
}


unsigned char BTxxx::readRemoteControl(char* buf)
{
	static bool init = false;

   if (!init)
   {
   	init = true;
	   i2cInit();
   }
   i2cStart();
	i2cWrite(0x35);
   unsigned char b1 = i2cRead();
   unsigned char b2 = i2cRead();
   unsigned char b3 = i2cRead();
	i2cSendNACK();
   i2cStop();

   if (buf)
   	sprintf(buf, "readRemoteControl %u %u %u", b1, b2, b3);

   return(0);
}
